// Kurs Background Service Worker
// Handles API requests to localhost to bypass Chrome's security restrictions

const API_URL = 'http://localhost:52525';

// Listen for messages from content scripts
chrome.runtime.onMessage.addListener((request, sender, sendResponse) => {
  if (request.action === 'fetch') {
    handleFetch(request)
      .then(sendResponse)
      .catch(error => sendResponse({ error: error.message }));
    return true; // Keep the message channel open for async response
  }
});

/**
 * Handle fetch requests from content scripts
 */
async function handleFetch(request) {
  const { endpoint, method = 'GET', body } = request;

  try {
    const options = {
      method,
      headers: {
        'Content-Type': 'application/json'
      }
    };

    if (body && method !== 'GET') {
      options.body = JSON.stringify(body);
    }

    const response = await fetch(`${API_URL}${endpoint}`, options);

    if (!response.ok) {
      return { error: `Server error: ${response.status}` };
    }

    const data = await response.json();
    return { success: true, data };

  } catch (error) {
    // Kurs app not running or network error
    return { error: error.message, notRunning: true };
  }
}
